//
//  OPRoomEvent.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/16/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPTrigger.h"
#import <OpenGL/gl.h>

@implementation OPTrigger
- (id)initWithEventData:(NSDictionary *)eventData
{
	self = [super init];
	if(self != nil) {
		OPPoint gridPoint = NSPointFromString([eventData objectForKey:@"Location"]);
		location.x = gridPoint.x * 32;
		location.y = gridPoint.y * 32;
		isDone = NO;
		repeatable = [[eventData objectForKey:@"Repeatable"] boolValue];
		actions = [[eventData objectForKey:@"Actions"] retain];
		identifier = nil;
	}
	return self;
}

- (void)setIdentifier:(NSString *)value
{
	identifier = [value retain];
}

- (NSString *)identifier
{
	return identifier;
}

- (OPRect)collisionRect
{
	return OPMakeRect(location.x + 2, location.y, 28, 16);
}

- (void)draw
{
	/*glBegin(GL_LINE_LOOP); {
		glColor3d(0, 0, 0);
		glVertex2d(location.x, location.y);
		glVertex2d(location.x + 32, location.y);
		glVertex2d(location.x + 32, location.y + 32);
		glVertex2d(location.x, location.y + 32);
	}
	glEnd();
	OPRect collisionRect = [self collisionRect];
	glBegin(GL_LINE_LOOP); {
		glColor3d(1.0, 0.0, 0.0);
		glVertex2d(collisionRect.origin.x, collisionRect.origin.y);
		glVertex2d(collisionRect.origin.x + collisionRect.size.width, collisionRect.origin.y);
		glVertex2d(collisionRect.origin.x + collisionRect.size.width, collisionRect.origin.y + collisionRect.size.height);
		glVertex2d(collisionRect.origin.x, collisionRect.origin.y + collisionRect.size.height);
		glColor3d(1.0, 1.0, 1.0);
	}
	glEnd();*/
 
}

- (void)dealloc
{
	[actions release];
	[identifier release];
	[super dealloc];
}

- (NSArray *)actions
{
	return actions;
}

- (BOOL)isDone
{
	return isDone;
}

- (void)setDone:(BOOL)value
{
	isDone = value;
}

- (NSDictionary *)parameters
{
	return nil;
}

- (BOOL)repeatable
{
	return repeatable;
}

- (OPPoint)location
{
	return location;
}

- (NSString *)description
{
	return [NSString stringWithFormat:@"%@ %@", [super description], actions];
}

@end
